/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.nbt.NbtAccounterException;

public class NbtAccounter {
    private static final int f_301619_ = 512;
    private final long f_128918_;
    private long f_128919_;
    private final int f_301621_;
    private int f_301623_;

    public NbtAccounter(long p_128922_, int p_301724_) {
        this.f_128918_ = p_128922_;
        this.f_301621_ = p_301724_;
    }

    public static NbtAccounter m_301677_(long p_301706_) {
        return new NbtAccounter(p_301706_, 512);
    }

    public static NbtAccounter m_301669_() {
        return new NbtAccounter(Long.MAX_VALUE, 512);
    }

    public void m_301853_(long p_301856_, long p_301857_) {
        this.m_263468_(p_301856_ * p_301857_);
    }

    public void m_263468_(long p_263515_) {
        if (this.f_128919_ + p_263515_ > this.f_128918_) {
            throw new NbtAccounterException("Tried to read NBT tag that was too big; tried to allocate: " + this.f_128919_ + " + " + p_263515_ + " bytes where max allowed: " + this.f_128918_);
        }
        this.f_128919_ += p_263515_;
    }

    public void m_301672_() {
        if (this.f_301623_ >= this.f_301621_) {
            throw new NbtAccounterException("Tried to read NBT tag with too high complexity, depth > " + this.f_301621_);
        }
        ++this.f_301623_;
    }

    public void m_301650_() {
        if (this.f_301623_ <= 0) {
            throw new NbtAccounterException("NBT-Accounter tried to pop stack-depth at top-level");
        }
        --this.f_301623_;
    }

    public String readUTF(String data) {
        this.m_263468_(2L);
        if (data == null) {
            return data;
        }
        int len = data.length();
        int utflen = 0;
        for (int i = 0; i < len; ++i) {
            char c = data.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.m_263468_(utflen);
        return data;
    }

    @VisibleForTesting
    public long m_263225_() {
        return this.f_128919_;
    }

    @VisibleForTesting
    public int m_301664_() {
        return this.f_301623_;
    }
}

