/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.google.common.jimfs.Jimfs;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.targets.CommonDevLaunchHandler;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@ApiStatus.Internal
abstract class ForgeDevLaunchHandler
extends CommonDevLaunchHandler {
    private static final String MODS_TOML = "META-INF/mods.toml";
    private static final String PACK_META = "pack.mcmeta";
    private static final UnionFileSystemProvider UFSP = (UnionFileSystemProvider)FileSystemProvider.installedProviders().stream().filter(fsp -> fsp.getScheme().equals("union")).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find UnionFileSystemProvider"));

    private ForgeDevLaunchHandler(CommonLaunchHandler.LaunchType type) {
        super(type, "forge_dev_");
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        Map<String, List<Path>> mods = ForgeDevLaunchHandler.getModClasses();
        String[] legacyCP = Objects.requireNonNull(System.getProperty("legacyClassPath"), "Missing legacyClassPath, cannot find client-extra").split(File.pathSeparator);
        Path extra = ForgeDevLaunchHandler.findJarOnClasspath(legacyCP, "client-extra");
        List<Path> minecraft = mods.remove("minecraft");
        if (minecraft == null) {
            throw new IllegalStateException("Could not find 'minecraft' mod paths.");
        }
        BiPredicate<String, String> mcFilter = this.getMcFilter(extra, minecraft);
        Stream.Builder<List<Path>> modstream = Stream.builder();
        Path forge = this.getForgeMod(minecraft);
        modstream.add(List.of(forge));
        List<Path> tests = mods.remove("tests");
        if (tests != null) {
            this.explodeTestMods(tests).forEach(modstream::add);
        }
        mods.values().forEach(modstream::add);
        return new CommonLaunchHandler.LocatedPaths(Stream.concat(minecraft.stream(), List.of(extra).stream()).toList(), mcFilter, modstream.build().toList(), this.getLibraries(legacyCP));
    }

    private List<List<Path>> explodeTestMods(List<Path> paths) {
        ArrayList<List<Path>> mod = new ArrayList<List<Path>>();
        FileSystem memory = Jimfs.newFileSystem();
        Map<String, Set<String>> packages = this.findTestModPackages(paths);
        for (Map.Entry<String, Set<String>> entry : packages.entrySet()) {
            String pkg = entry.getKey();
            Set<String> modids = entry.getValue();
            LinkedHashSet<Path> resourcePaths = new LinkedHashSet<Path>();
            paths.stream().mapMulti((p, c) -> modids.forEach(id -> c.accept(p.resolve((String)id)))).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(resourcePaths::add);
            Path root = memory.getPath(modids.iterator().next(), new String[0]);
            this.buildModsToml(resourcePaths, modids, root);
            this.buildPackMeta(resourcePaths, root);
            if (Files.exists(root, new LinkOption[0])) {
                resourcePaths.add(root);
            }
            UnionFileSystem classes = UFSP.newFileSystem((path, base) -> {
                if (path.endsWith("/")) {
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    return pkg.startsWith((String)path) || path.startsWith(pkg);
                }
                return path.endsWith(".class") && path.startsWith(pkg);
            }, (Path[])paths.toArray(Path[]::new));
            UnionFileSystem resources = UFSP.newFileSystem((path, base) -> !path.endsWith(".class"), (Path[])resourcePaths.toArray(Path[]::new));
            mod.add(List.of(classes.getRoot(), resources.getRoot()));
        }
        return mod;
    }

    private Map<String, Set<String>> findTestModPackages(List<Path> paths) {
        final HashMap<String, Set<String>> mods = new HashMap<String, Set<String>>();
        for (Path path : paths) {
            try {
                Stream<Path> files = Files.walk(path, new FileVisitOption[0]);
                try {
                    List<Path> classes = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".class")).toList();
                    for (Path cls : classes) {
                        InputStream is = Files.newInputStream(cls, new OpenOption[0]);
                        try {
                            ClassReader reader = new ClassReader(is);
                            reader.accept(new ClassVisitor(589824){
                                private String clsName;

                                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                    this.clsName = name;
                                    super.visit(version, access, name, signature, superName, interfaces);
                                }

                                public AnnotationVisitor visitAnnotation(String name, boolean runtime) {
                                    if (!"Lnet/minecraftforge/fml/common/Mod;".equals(name)) {
                                        return super.visitAnnotation(name, runtime);
                                    }
                                    return new AnnotationVisitor(589824){

                                        public void visit(String key, Object value) {
                                            if ("value".equals(key)) {
                                                int idx = clsName.lastIndexOf(47);
                                                String pkg = clsName.substring(0, idx);
                                                mods.computeIfAbsent(pkg, k -> new HashSet()).add((String)value);
                                                idx = pkg.lastIndexOf(47);
                                                while (idx != -1) {
                                                    pkg = pkg.substring(0, idx);
                                                    idx = pkg.lastIndexOf(47);
                                                    if (!mods.containsKey(pkg)) continue;
                                                    throw new IllegalStateException("Invalid ForgeDev test mod layout, conflicting packages: " + pkg + " for " + clsName);
                                                }
                                            }
                                        }
                                    };
                                }
                            }, 7);
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            catch (IOException e) {
                ForgeDevLaunchHandler.sneak(e);
            }
        }
        return mods;
    }

    private void buildModsToml(Set<Path> resources, Set<String> modids, Path root) {
        Path toml = resources.stream().map(p -> p.resolve(MODS_TOML)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElse(null);
        Config cfg = null;
        cfg = toml != null ? new TomlParser().parse(toml, FileNotFoundAction.READ_NOTHING) : Config.inMemory();
        boolean modified = false;
        Map<String, String> defaults = Map.of("modLoader", "javafml", "loaderVersion", "[0,)", "license", "Doesnt fucking matter");
        for (String key : defaults.keySet()) {
            if (cfg.contains(key)) continue;
            cfg.set(key, (Object)defaults.get(key));
            modified = true;
        }
        ArrayList<Config> modlist = new ArrayList<Config>();
        if (cfg.contains("mods")) {
            List existing = (List)cfg.get("mods");
            modlist.addAll(existing);
        }
        for (String modid : modids) {
            if (modlist.stream().anyMatch(c -> modid.equals(c.get("modId")))) continue;
            modified = true;
            Config tmp = Config.inMemory();
            tmp.set("modId", (Object)modid);
            modlist.add(tmp);
        }
        cfg.set("mods", modlist);
        if (modified) {
            Path target = root.resolve(MODS_TOML);
            try {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                new TomlWriter().write((UnmodifiableConfig)cfg, target, WritingMode.REPLACE);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create in memory toml: " + target, e);
            }
        }
    }

    private void buildPackMeta(Set<Path> paths, Path root) {
        Path existing = paths.stream().map(p -> p.resolve(PACK_META)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElse(null);
        if (existing != null) {
            return;
        }
        Path target = root.resolve(PACK_META);
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.writeString(target, (CharSequence)"{\n    \"pack\": {\n        \"description\": \"doesn't matter\",\n        \"pack_format\": 18\n     }\n}\n", StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to make in memory pack.mcmeta: " + target, e);
        }
    }

    private static <E extends Throwable, R> R sneak(Throwable e) throws E {
        throw e;
    }

    public static class ServerGameTest
    extends ForgeDevLaunchHandler {
        public ServerGameTest() {
            super(SERVER_GAMETEST);
        }
    }

    public static class Server
    extends ForgeDevLaunchHandler {
        public Server() {
            super(SERVER);
        }
    }

    public static class Data
    extends ForgeDevLaunchHandler {
        public Data() {
            super(DATA);
        }
    }

    public static class Client
    extends ForgeDevLaunchHandler {
        public Client() {
            super(CLIENT);
        }
    }
}

