/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.VersionInfo;
import net.minecraftforge.fml.loading.targets.CommonDevLaunchHandler;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class ForgeUserdevLaunchHandler
extends CommonDevLaunchHandler {
    private ForgeUserdevLaunchHandler(CommonLaunchHandler.LaunchType type) {
        super(type, "forge_userdev_");
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        String[] legacyCP = Objects.requireNonNull(System.getProperty("legacyClassPath"), "Missing legacyClassPath, cannot find userdev jars").split(File.pathSeparator);
        VersionInfo vers = FMLLoader.versionInfo();
        Path extra = ForgeUserdevLaunchHandler.findJarOnClasspath(legacyCP, "client-extra");
        Path forge = ForgeUserdevLaunchHandler.findJarOnClasspath(legacyCP, "forge-" + vers.mcAndForgeVersion());
        BiPredicate<String, String> filter = this.getMcFilter(extra, List.of(forge));
        Stream.Builder<List<Path>> modstream = Stream.builder();
        Path forgemod = this.getForgeMod(List.of(forge));
        modstream.add(List.of(forgemod));
        ForgeUserdevLaunchHandler.getModClasses().forEach((modid, paths) -> modstream.add((List<Path>)paths));
        return new CommonLaunchHandler.LocatedPaths(List.of(forge, extra), filter, modstream.build().toList(), this.getLibraries(legacyCP));
    }

    public static class ServerGameTest
    extends ForgeUserdevLaunchHandler {
        public ServerGameTest() {
            super(SERVER_GAMETEST);
        }
    }

    public static class Server
    extends ForgeUserdevLaunchHandler {
        public Server() {
            super(SERVER);
        }
    }

    public static class Data
    extends ForgeUserdevLaunchHandler {
        public Data() {
            super(DATA);
        }
    }

    public static class Client
    extends ForgeUserdevLaunchHandler {
        public Client() {
            super(CLIENT);
        }
    }
}

