/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.block;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.command.LuckyCommandLogic;
import mod.lucky.crafting.LuckyCrafting;
import mod.lucky.drop.DropContainer;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.item.ItemLuckyBlock;
import mod.lucky.tileentity.TileEntityLuckyBlock;
import mod.lucky.util.LuckyFunction;
import mod.lucky.world.LuckyGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class BlockLuckyBlock
extends BlockContainer {
    private DropProcessor dropProcessor;
    private LuckyGenerator worldGenerator;
    private LuckyCrafting crafting;
    private boolean creativeModeDrops = false;
    private final Random random = new Random();

    public BlockLuckyBlock(Material material) {
        super(material);
        this.dropProcessor = new DropProcessor();
        this.worldGenerator = new LuckyGenerator(this);
        this.crafting = new LuckyCrafting((Block)this);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175689_h(pos);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (world.func_175640_z(pos)) {
            this.removeLuckyBlock(world, null, pos, true);
        }
    }

    public boolean removedByPlayer(World world, BlockPos harvestPos, EntityPlayer player, boolean willharvest) {
        return this.removeLuckyBlock(world, player, harvestPos, false);
    }

    public boolean removeLuckyBlock(World world, EntityPlayer player, BlockPos harvestPos, boolean removedByRedstone) {
        try {
            int luck = 0;
            String[] customDropsRaw = null;
            ArrayList<DropContainer> customDrops = null;
            TileEntityLuckyBlock tileEntityLuck = (TileEntityLuckyBlock)world.func_175625_s(harvestPos);
            if (tileEntityLuck != null) {
                luck = tileEntityLuck.getLuck();
                customDropsRaw = tileEntityLuck.getDrops();
                if (customDropsRaw != null && customDropsRaw.length != 0) {
                    customDrops = new ArrayList<DropContainer>();
                    for (String rawDrop : customDropsRaw) {
                        DropContainer dropContainer = new DropContainer();
                        dropContainer.readFromString(rawDrop);
                        customDrops.add(dropContainer);
                    }
                }
                world.func_175713_t(harvestPos);
            }
            if (!world.func_175698_g(harvestPos)) {
                return false;
            }
            if (!world.field_72995_K) {
                if (removedByRedstone) {
                    LuckyCommandLogic luckyCommandLogic = new LuckyCommandLogic();
                    luckyCommandLogic.setWorld(world);
                    luckyCommandLogic.setPosition(harvestPos);
                    player = PlayerSelector.func_82386_a((ICommandSender)luckyCommandLogic, (String)"@p");
                }
                if (player.field_71075_bZ.field_75098_d && !this.creativeModeDrops && !removedByRedstone) {
                    return true;
                }
                if (EnchantmentHelper.func_77502_d((EntityLivingBase)player) && !removedByRedstone) {
                    ItemStack itemStack = new ItemStack((Block)this);
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    if (luck != 0) {
                        tagCompound.func_74768_a("Luck", luck);
                    }
                    if (customDrops != null) {
                        tagCompound.func_74782_a("Drops", (NBTBase)LuckyFunction.getNBTTagListFromStringArray(customDropsRaw));
                    }
                    if (tagCompound.func_74764_b("Luck") || customDrops != null) {
                        itemStack.func_77982_d(tagCompound);
                    }
                    Block.func_180635_a((World)world, (BlockPos)harvestPos, (ItemStack)itemStack);
                    return true;
                }
                if (customDrops != null) {
                    this.getDropProcessor().processRandomDrop(customDrops, new DropProcessData(world, (Entity)player, harvestPos), luck);
                } else {
                    this.getDropProcessor().processRandomDrop(new DropProcessData(world, (Entity)player, harvestPos), luck);
                }
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Block encountered and error while trying to perform a function. Error report below:");
            e.printStackTrace();
        }
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    private boolean canStayOnBlock(Block soil) {
        return soil == Blocks.field_150349_c || soil == Blocks.field_150346_d || soil == Blocks.field_150354_m || soil == Blocks.field_150348_b || soil == Blocks.field_150351_n || soil == Blocks.field_150424_aL || soil == Blocks.field_150425_aM || soil == Blocks.field_150385_bj || soil == Blocks.field_150385_bj || soil == Blocks.field_150377_bs;
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        Block curBlock = world.func_180495_p(pos).func_177230_c();
        Block soil = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_177230_c();
        return curBlock.func_176200_f(world, pos) && curBlock != Blocks.field_150355_j && curBlock != Blocks.field_150358_i && curBlock != Blocks.field_150353_l && curBlock != Blocks.field_150356_k && (world.getBlockLightOpacity(pos) >= 8 || world.func_175710_j(pos)) && soil != null && this.canStayOnBlock(soil);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityLuckyBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemStack) {
        TileEntityLuckyBlock tileEntityLuck = (TileEntityLuckyBlock)world.func_175625_s(pos);
        if (tileEntityLuck == null) {
            return;
        }
        int luck = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        tileEntityLuck.setLuck(luck);
        if (drops != null && drops.length != 0) {
            tileEntityLuck.setDrops(drops);
        }
        tileEntityLuck.func_70296_d();
        world.func_175689_h(pos);
        if (world.func_175640_z(pos) && !world.field_72995_K) {
            this.removeLuckyBlock(world, null, pos, true);
        }
    }

    public DropProcessor getDropProcessor() {
        return this.dropProcessor;
    }

    public LuckyGenerator getWorldGenerator() {
        return this.worldGenerator;
    }

    public LuckyCrafting getCrafting() {
        return this.crafting;
    }

    public boolean getCrativeModeDrops() {
        return this.creativeModeDrops;
    }

    public void setCrativeModeDrops(boolean creativeModeDrops) {
        this.creativeModeDrops = creativeModeDrops;
    }

    public int func_149645_b() {
        return 3;
    }
}

