/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.client;

import com.google.common.base.Charsets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.imageio.ImageIO;
import mod.lucky.client.LuckyBlockModel;
import mod.lucky.client.LuckyBlockTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ITransformation;

public class LuckyBlockModelLoader
implements ICustomModelLoader {
    public static LuckyBlockModelLoader instance;
    private FaceBakery faceBakery;

    public LuckyBlockModelLoader() {
        instance = this;
        this.faceBakery = new FaceBakery();
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110624_b().equals("lucky");
    }

    public IModel loadModel(ResourceLocation modelLocation) {
        return new LuckyBlockModel(modelLocation);
    }

    public ModelBlock loadModelBlock(ResourceLocation modelLocation) {
        try {
            IResource iresource = null;
            try {
                iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.getModelLocation(modelLocation));
            }
            catch (IOException e) {
                System.err.println("Lucky Block: Failed to load block model from location: " + modelLocation.toString());
                e.printStackTrace();
            }
            InputStreamReader reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
            ModelBlock modelBlock = ModelBlock.func_178307_a((Reader)reader);
            modelBlock.field_178317_b = modelLocation.toString();
            ((Reader)reader).close();
            if (modelBlock.func_178305_e() != null) {
                modelBlock.field_178315_d = this.loadModelBlock(modelBlock.func_178305_e());
            }
            return modelBlock;
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Failed to load block model from location: " + modelLocation.toString());
            e.printStackTrace();
            return null;
        }
    }

    private ResourceLocation getModelLocation(ResourceLocation modelLocation) {
        return new ResourceLocation(modelLocation.func_110624_b(), (modelLocation.func_110623_a().startsWith("models/") ? "" : "models/") + modelLocation.func_110623_a() + ".json");
    }

    public IFlexibleBakedModel bakeModel(ModelBlock modelBlockIn, ITransformation modelRotationIn, boolean uvLocked) {
        LuckyBlockTexture luckyBlockTexture = new LuckyBlockTexture();
        try {
            BufferedImage image = ImageIO.read(new File("./lucky_block.png"));
            luckyBlockTexture.loadSprite(image, null);
            luckyBlockTexture.func_147963_d(Minecraft.func_71410_x().field_71474_y.field_151442_I);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        luckyBlockTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b("lucky:blocks/lucky_block_custom");
        TextureAtlasSprite spongeTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/sponge");
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(modelBlockIn).func_177646_a((TextureAtlasSprite)luckyBlockTexture);
        for (BlockPart blockpart : modelBlockIn.func_178298_a()) {
            for (EnumFacing enumfacing : blockpart.field_178240_c.keySet()) {
                BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(enumfacing);
                if (blockpartface.field_178244_b == null) {
                    builder.func_177648_a(this.makeBakedQuad(blockpart, blockpartface, luckyBlockTexture, enumfacing, modelRotationIn, uvLocked));
                    continue;
                }
                builder.func_177650_a(modelRotationIn.rotate(blockpartface.field_178244_b), this.makeBakedQuad(blockpart, blockpartface, luckyBlockTexture, enumfacing, modelRotationIn, uvLocked));
            }
        }
        return new IFlexibleBakedModel.Wrapper(builder.func_177645_b(), Attributes.DEFAULT_BAKED_FORMAT);
    }

    private BakedQuad makeBakedQuad(BlockPart p_177589_1_, BlockPartFace p_177589_2_, TextureAtlasSprite p_177589_3_, EnumFacing p_177589_4_, ITransformation p_177589_5_, boolean p_177589_6_) {
        return this.faceBakery.makeBakedQuad(p_177589_1_.field_178241_a, p_177589_1_.field_178239_b, p_177589_2_, p_177589_3_, p_177589_4_, p_177589_5_, p_177589_1_.field_178237_d, p_177589_6_, p_177589_1_.field_178238_e);
    }
}

