/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.value;

import java.util.ArrayList;
import java.util.Random;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import mod.lucky.drop.LuckyDropOld;
import mod.lucky.drop.value.CustomNBTTags;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.structure.rotation.Rotations;
import mod.lucky.util.LuckyFunction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ExpressionParserOld {
    public static final ExpressionParserOld instance = new ExpressionParserOld();
    private final ScriptEngine scriptEngine;
    private final Random random;
    public EntityPlayer player;
    public World world;
    public int harvestX;
    public int harvestY;
    public int harvestZ;
    public LuckyDropOld structDrop;
    public static String[] hashVariables = new String[]{"#randomPotionDamage", "#randomPotionEffect", "#randomSpawnEggDamage", "#bPosX", "#bPosY", "#bPos", "#time", "#pPosX", "#pPosY", "#pPosZ", "#pPos", "#playerName", "#playerDirect", "#playerYaw", "#playerPitch", "#posX", "#posY", "#posZ", "#pos", "#rotation"};
    public static String[] propertyStrings = new String[]{"#rand(", "#randPosNeg(", "#randList(", "#sPosX(", "#sPosY(", "#sPosZ(", "#sPos("};

    public ExpressionParserOld() {
        ScriptEngineManager mgr = new ScriptEngineManager(null);
        this.scriptEngine = mgr.getEngineByName("JavaScript");
        this.random = new Random();
    }

    public void initialize(World world, EntityPlayer player, BlockPos pos) {
        this.world = world;
        this.player = player;
        this.harvestX = pos.func_177958_n();
        this.harvestY = pos.func_177956_o();
        this.harvestZ = pos.func_177952_p();
    }

    private String getFormattedString(String value) throws ExpressionParserException {
        value = this.replaceProperties(value);
        value = value.replaceAll("#randomPotionDamage", String.valueOf(LuckyFunction.getRandomPotionDamage()));
        value = value.replaceAll("#randomPotionEffect", String.valueOf(LuckyFunction.getRandomStatusEffect()));
        value = value.replaceAll("#randomSpawnEggDamage", String.valueOf(LuckyFunction.getRandomMobEgg()));
        value = value.replaceAll("#bPosX", String.valueOf(this.harvestX));
        value = value.replaceAll("#bPosY", String.valueOf(this.harvestY));
        value = value.replaceAll("#bPosZ", String.valueOf(this.harvestZ));
        value = value.replaceAll("#bPos", String.valueOf("(" + this.harvestX + "," + this.harvestY + "," + this.harvestZ + ")"));
        if (this.world != null) {
            value = value.replaceAll("#time", String.valueOf(this.world.func_72820_D()));
        }
        if (this.player != null) {
            int pPosX = MathHelper.func_76128_c((double)this.player.field_70165_t);
            int pPosY = MathHelper.func_76128_c((double)this.player.field_70163_u);
            int pPosZ = MathHelper.func_76128_c((double)this.player.field_70161_v);
            value = value.replaceAll("#pPosX", String.valueOf(pPosX));
            value = value.replaceAll("#pPosY", String.valueOf(pPosY));
            value = value.replaceAll("#pPosZ", String.valueOf(pPosZ));
            value = value.replaceAll("#pPos", String.valueOf("(" + pPosX + "," + pPosY + "," + pPosZ + ")"));
            value = value.replaceAll("#playerName", this.player.func_145748_c_().func_150260_c());
            int playerRotation = (int)Math.round(((double)this.player.field_70177_z + 180.0) / 90.0) % 4;
            if (playerRotation < 0) {
                playerRotation += 4;
            }
            value = value.replaceAll("#playerDirect", String.valueOf(playerRotation));
            value = value.replaceAll("#playerYaw", String.valueOf(this.player.field_70177_z));
            value = value.replaceAll("#playerPitch", String.valueOf(this.player.field_70125_A));
        }
        if (this.structDrop != null) {
            value = value.replaceAll("#posX", String.valueOf(this.structDrop.getPosX()));
            value = value.replaceAll("#posY", String.valueOf(this.structDrop.getPosY()));
            value = value.replaceAll("#posZ", String.valueOf(this.structDrop.getPosZ()));
            value = value.replaceAll("#pos", String.valueOf("(" + this.structDrop.getPosX() + "," + this.structDrop.getPosY() + "," + this.structDrop.getPosZ() + ")"));
            value = value.replaceAll("#rotation", String.valueOf(this.structDrop.getRotation()));
        }
        value = value.replaceAll("'#'", "'\u00a7'");
        value = value.replaceAll("#", "\u00a7");
        value = value.replaceAll("'\u00a7'", "#");
        return value;
    }

    private String fixBackslash(String value) {
        value = value.replaceAll("\\\\t", "\t");
        value = value.replaceAll("\\\\b", "\b");
        value = value.replaceAll("\\\\n", "\n");
        value = value.replaceAll("\\\\r", "\r");
        value = value.replaceAll("\\\\f", "\f");
        return value;
    }

    public String replaceProperties(String value) throws ExpressionParserException {
        ArrayList<Integer> points = new ArrayList<Integer>();
        int count = 0;
        while (true) {
            int minPoint = -1;
            int minIndex = -1;
            for (int i = 0; i < propertyStrings.length; ++i) {
                int point = value.indexOf(propertyStrings[i], count == 0 ? 0 : (Integer)points.get(count - 1) + 1);
                if (point == -1 || minPoint != -1 && point >= minPoint) continue;
                minPoint = point;
                minIndex = i;
            }
            if (minPoint == -1) break;
            int propertyType = minIndex;
            int randomStringLength = propertyStrings[minIndex].length();
            points.add(count, minPoint);
            String curRandom = "";
            int curEndPoint = -1;
            char[] lineChar = value.toCharArray();
            int bracketTier = 0;
            boolean inQuotesBefore = false;
            boolean inQuotesNow = false;
            char[] newLine = new char[lineChar.length];
            int writeIndex = 0;
            for (int i = 0; i < lineChar.length; ++i) {
                boolean charCanceled = i > 0 && lineChar[i - 1] == '\\';
                newLine[writeIndex] = lineChar[i];
                if (i >= (Integer)points.get(count) + randomStringLength - 1) {
                    if (!charCanceled) {
                        if (lineChar[i] == '\"') {
                            boolean bl = inQuotesNow = !inQuotesNow;
                        }
                        if (!(lineChar[i] != '(' && lineChar[i] != '[' && lineChar[i] != '{' || inQuotesNow)) {
                            ++bracketTier;
                        }
                        if (!(lineChar[i] != ')' && lineChar[i] != ']' && lineChar[i] != '}' || inQuotesNow)) {
                            --bracketTier;
                        }
                        if (bracketTier == 0) {
                            char[] newLinefinal = new char[writeIndex];
                            for (int j = 0; j < newLinefinal.length; ++j) {
                                newLinefinal[j] = newLine[j];
                            }
                            curRandom = new String(newLinefinal);
                            curEndPoint = i;
                            break;
                        }
                    }
                    if (lineChar[i] == '\"' && charCanceled && inQuotesBefore) {
                        boolean charDoubleCanceled;
                        newLine[--writeIndex] = 34;
                        boolean bl = charDoubleCanceled = i > 1 && lineChar[i - 2] == '\\';
                        if (!charDoubleCanceled) {
                            inQuotesNow = !inQuotesNow;
                        }
                    }
                } else if (lineChar[i] == '\"' && !charCanceled) {
                    inQuotesBefore = !inQuotesBefore;
                }
                ++writeIndex;
            }
            curRandom = curRandom.substring((Integer)points.get(count) + randomStringLength, curRandom.length());
            String[] splitValue = DropStringUtils.splitBracketString(curRandom, ',');
            String result = "";
            if (propertyType == 0 || propertyType == 1) {
                boolean isFloat = this.isFloat(splitValue[0]) || this.isFloat(splitValue[1]);
                splitValue[0] = this.removeSuffix(splitValue[0]);
                splitValue[1] = this.removeSuffix(splitValue[1]);
                if (isFloat) {
                    float min = this.getFloat(splitValue[0]);
                    float max = this.getFloat(splitValue[1]);
                    float num = MathHelper.func_151240_a((Random)this.random, (float)min, (float)max);
                    if (propertyType == 1 && this.random.nextInt(2) == 0) {
                        num *= -1.0f;
                    }
                    result = String.valueOf(num);
                } else {
                    int min = this.getInteger(splitValue[0]);
                    int max = this.getInteger(splitValue[1]);
                    int num = this.random.nextInt(max - min + 1) + min;
                    if (propertyType == 1 && this.random.nextInt(2) == 0) {
                        num *= -1;
                    }
                    result = String.valueOf(num);
                }
            } else if (propertyType == 2) {
                int index = this.random.nextInt(splitValue.length);
                result = this.getString(splitValue[index]);
            } else if (propertyType == 3 || propertyType == 4 || propertyType == 5 || propertyType == 6) {
                if (this.structDrop != null) {
                    boolean isFloat = this.isFloat(splitValue[0]) || this.isFloat(splitValue[1]) || this.isFloat(splitValue[2]);
                    splitValue[0] = this.removeSuffix(splitValue[0]);
                    splitValue[1] = this.removeSuffix(splitValue[1]);
                    splitValue[2] = this.removeSuffix(splitValue[2]);
                    Vec3 blockPos = new Vec3((double)this.getFloat(splitValue[0]), (double)this.getFloat(splitValue[1]), (double)this.getFloat(splitValue[2]));
                    int rotation = this.structDrop.rotation;
                    double xOffset = (double)this.structDrop.centerX - blockPos.field_72450_a;
                    double yOffset = (double)this.structDrop.centerY - blockPos.field_72448_b;
                    double zOffset = (double)this.structDrop.centerZ - blockPos.field_72449_c;
                    Vec3 resultPos = new Vec3((double)this.harvestX - xOffset, (double)this.harvestY - yOffset, (double)this.harvestZ - zOffset);
                    resultPos = Rotations.rotatePos(resultPos, new Vec3((double)this.harvestX, (double)this.harvestY, (double)this.harvestZ), rotation);
                    if (isFloat) {
                        if (propertyType == 3) {
                            result = String.valueOf((float)resultPos.field_72450_a);
                        }
                        if (propertyType == 4) {
                            result = String.valueOf((float)resultPos.field_72448_b);
                        }
                        if (propertyType == 5) {
                            result = String.valueOf((float)resultPos.field_72449_c);
                        }
                        if (propertyType == 6) {
                            result = String.valueOf(String.valueOf("(" + (float)resultPos.field_72450_a + "," + (float)resultPos.field_72448_b + "," + (float)resultPos.field_72449_c + ")"));
                        }
                    } else {
                        if (propertyType == 3) {
                            result = String.valueOf(Math.round(resultPos.field_72450_a));
                        }
                        if (propertyType == 4) {
                            result = String.valueOf(Math.round(resultPos.field_72448_b));
                        }
                        if (propertyType == 5) {
                            result = String.valueOf(Math.round(resultPos.field_72449_c));
                        }
                        if (propertyType == 6) {
                            result = String.valueOf(String.valueOf("(" + Math.round(resultPos.field_72450_a) + "," + Math.round(resultPos.field_72448_b) + "," + Math.round(resultPos.field_72449_c) + ")"));
                        }
                    }
                } else {
                    result = "0";
                }
            }
            String valuePart1 = value.substring(0, (Integer)points.get(count));
            String valuePart2 = value.substring(curEndPoint + 1, value.length());
            value = valuePart1 + result + valuePart2;
            ++count;
        }
        return value;
    }

    public int getEndPoint(String value, int startPoint, char ... invalidChars) {
        char[] chars = value.toCharArray();
        int endPoint = chars.length;
        for (int i = startPoint; i < chars.length; ++i) {
            boolean shouldBreak = false;
            for (char invalidChar : invalidChars) {
                if (chars[i] != invalidChar) continue;
                endPoint = i;
                shouldBreak = true;
                break;
            }
            if (shouldBreak) break;
        }
        return endPoint;
    }

    public boolean isFloat(String s) {
        boolean endsWithDecimalPoint = false;
        for (int i = s.length() - 1; i >= 0; --i) {
            if (Character.isDigit(s.charAt(i))) continue;
            if (s.charAt(i) != '.') break;
            endsWithDecimalPoint = true;
            break;
        }
        return s.endsWith("f") || s.endsWith("F") || s.endsWith("d") || s.endsWith("D") || endsWithDecimalPoint;
    }

    public boolean isDouble(String s) {
        boolean endsWithDecimalPoint = false;
        for (int i = s.length() - 1; i >= 0; --i) {
            if (Character.isDigit(s.charAt(i))) continue;
            if (s.charAt(i) != '.') break;
            endsWithDecimalPoint = true;
            break;
        }
        return s.endsWith("d") || s.endsWith("D") || endsWithDecimalPoint;
    }

    public String removeSuffix(String s) {
        if (s.endsWith("f") || s.endsWith("F") || s.endsWith("d") || s.endsWith("D") || s.endsWith("s") || s.endsWith("S") || s.endsWith("b") || s.endsWith("B")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public NBTBase getFormattedNBT(NBTBase tag) {
        if (tag instanceof NBTTagString) {
            try {
                return this.getNBTValueFromString(((NBTTagString)tag).func_150285_a_());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tag instanceof NBTTagCompound) {
            for (Object key : ((NBTTagCompound)tag).func_150296_c()) {
                NBTBase tagContent = this.getFormattedNBT(((NBTTagCompound)tag).func_74781_a((String)key));
                ((NBTTagCompound)tag).func_74782_a((String)key, tagContent);
            }
        }
        if (tag instanceof NBTTagList) {
            if (((NBTTagList)tag).func_150303_d() == 8) {
                for (int i = 0; i < ((NBTTagList)tag).func_74745_c(); ++i) {
                    String string = ((NBTTagList)tag).func_150307_f(i);
                    NBTBase newString = this.getNBTValueFromString(string);
                    ((NBTTagList)tag).func_150304_a(i, newString);
                }
            }
            if (((NBTTagList)tag).func_150303_d() == 10) {
                for (int i = 0; i < ((NBTTagList)tag).func_74745_c(); ++i) {
                    NBTTagCompound tagCompound = ((NBTTagList)tag).func_150305_b(i);
                    NBTTagCompound newTagCompound = (NBTTagCompound)this.getFormattedNBT((NBTBase)tagCompound);
                    ((NBTTagList)tag).func_150304_a(i, (NBTBase)newTagCompound);
                }
            }
        }
        return tag;
    }

    public NBTBase getNBTValueFromString(String string) {
        try {
            String result = this.getFormattedString(string);
            return new NBTTagString(result);
        }
        catch (Exception e) {
            return new NBTTagString(string);
        }
    }

    private Object getFormattedObject(String tagValue) {
        Object result = tagValue;
        try {
            if (tagValue.endsWith("d") || tagValue.endsWith("D")) {
                result = this.getDouble(tagValue.substring(0, tagValue.length() - 1));
            } else if (tagValue.endsWith("f") || tagValue.endsWith("F")) {
                result = Float.valueOf(this.getFloat(tagValue.substring(0, tagValue.length() - 1)));
            } else if (tagValue.endsWith("s") || tagValue.endsWith("S")) {
                result = this.getShort(tagValue.substring(0, tagValue.length() - 1));
            } else if (tagValue.endsWith("b") || tagValue.endsWith("B")) {
                result = this.getByte(tagValue.substring(0, tagValue.length() - 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean containsHashVariables(String value) {
        for (String hashVariable : hashVariables) {
            if (!value.contains(hashVariable)) continue;
            return true;
        }
        for (String hashVariable : propertyStrings) {
            if (!value.contains(hashVariable)) continue;
            return true;
        }
        for (String hashVariable : CustomNBTTags.nbtHashVariables) {
            if (!value.contains(hashVariable)) continue;
            return true;
        }
        return false;
    }

    public Object getObject(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scriptEngine.eval(value);
            return obj;
        }
        catch (Exception e) {
            return value;
        }
    }

    public Object getObject(String value, Class valueType) throws ExpressionParserException {
        value = this.getFormattedString(value);
        if (valueType == String.class) {
            return this.getString(value);
        }
        if (valueType == Integer.class) {
            return this.getInteger(value);
        }
        if (valueType == Boolean.class) {
            return this.getBoolean(value);
        }
        if (valueType == Float.class) {
            return Float.valueOf(this.getFloat(value));
        }
        if (valueType == Double.class) {
            return this.getDouble(value);
        }
        if (valueType == Short.class) {
            return this.getShort(value);
        }
        if (valueType == Byte.class) {
            return this.getByte(value);
        }
        if (valueType == NBTTagCompound.class) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getNBTTag((NBTBase)new NBTTagCompound(), value);
            return tag;
        }
        return null;
    }

    public String getString(String value) throws ExpressionParserException {
        value = value.trim();
        value = this.getFormattedString(value);
        try {
            Object obj = this.scriptEngine.eval(value);
            if (obj instanceof String) {
                String s = (String)obj;
                return this.fixBackslash(s);
            }
            if (obj instanceof Double && String.valueOf(obj).endsWith(".0")) {
                String s = String.valueOf(obj);
                int i = this.getInteger(s);
                return this.fixBackslash(String.valueOf(i));
            }
            return this.fixBackslash(String.valueOf(obj));
        }
        catch (Exception e) {
            return value;
        }
    }

    public boolean getBoolean(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scriptEngine.eval(value);
            if (obj instanceof Boolean) {
                boolean b = (Boolean)obj;
                return b;
            }
            throw new ExpressionParserException(value, null);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public int getInteger(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scriptEngine.eval(value);
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Double) {
                double d = (Double)obj;
                return (int)d;
            }
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return (int)f;
            }
            throw new ExpressionParserException(value, null);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public double getDouble(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scriptEngine.eval(value);
            if (obj instanceof Double) {
                double d = (Double)obj;
                return d;
            }
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return f;
            }
            throw new ExpressionParserException(value, null);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public float getFloat(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scriptEngine.eval(value);
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return f;
            }
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Double) {
                double d = (Double)obj;
                return (float)d;
            }
            throw new ExpressionParserException(value, null);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public short getShort(String value) throws ExpressionParserException {
        try {
            return (short)this.getInteger(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public byte getByte(String value) throws ExpressionParserException {
        try {
            return (byte)this.getInteger(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public void getNBTTag(NBTBase currTag, String tagLine) throws ExpressionParserException {
        String[] tagContents;
        for (String tagContent : tagContents = DropStringUtils.splitBracketString(tagLine.substring(1, tagLine.length() - 1), ',')) {
            String tagValue;
            if (tagContent == null || tagContent.equals("")) continue;
            String tagName = currTag instanceof NBTTagCompound ? tagContent.substring(0, tagContent.indexOf("=")) : "";
            String string = tagValue = currTag instanceof NBTTagCompound ? tagContent.substring(tagContent.indexOf("=") + 1) : tagContent;
            if (tagName.equals("id")) {
                try {
                    Item item = (Item)Item.field_150901_e.func_82594_a((Object)this.getString(tagValue));
                    if (item != null) {
                        this.setTagValue(currTag, tagName, Item.field_150901_e.func_148757_b((Object)item));
                        continue;
                    }
                }
                catch (Exception item) {
                    // empty catch block
                }
            }
            NBTBase customTag = CustomNBTTags.getNBTTagFromString(tagValue, null);
            if (tagValue.startsWith("#") && customTag != null) {
                this.setTagValue(currTag, tagName, customTag);
                continue;
            }
            if (tagValue.startsWith("(") && tagValue.endsWith(")")) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                this.getNBTTag((NBTBase)tagCompound, tagValue);
                this.setTagValue(currTag, tagName, tagCompound);
                continue;
            }
            if (tagValue.startsWith("[") && tagValue.endsWith("]")) {
                NBTTagList tagList = new NBTTagList();
                this.getNBTTag((NBTBase)tagList, tagValue);
                this.setTagValue(currTag, tagName, tagList);
                continue;
            }
            if (tagValue.startsWith("\"") && tagValue.endsWith("\"")) {
                this.setTagValue(currTag, tagName, this.getString(tagValue));
                continue;
            }
            try {
                if (tagValue.endsWith("d") || tagValue.endsWith("D") || this.isDouble(tagValue)) {
                    this.setTagValue(currTag, tagName, this.getDouble(tagValue.substring(0, tagValue.length() - 1)));
                    continue;
                }
                if (tagValue.endsWith("f") || tagValue.endsWith("F")) {
                    this.setTagValue(currTag, tagName, Float.valueOf(this.getFloat(tagValue.substring(0, tagValue.length() - 1))));
                    continue;
                }
                if (tagValue.endsWith("s") || tagValue.endsWith("S")) {
                    this.setTagValue(currTag, tagName, this.getShort(tagValue.substring(0, tagValue.length() - 1)));
                    continue;
                }
                if (tagValue.endsWith("b") || tagValue.endsWith("B")) {
                    this.setTagValue(currTag, tagName, this.getByte(tagValue.substring(0, tagValue.length() - 1)));
                    continue;
                }
                throw new ExpressionParserException();
            }
            catch (ExpressionParserException e0) {
                try {
                    this.setTagValue(currTag, tagName, this.getInteger(tagValue));
                }
                catch (ExpressionParserException e1) {
                    try {
                        this.setTagValue(currTag, tagName, this.getBoolean(tagValue));
                    }
                    catch (ExpressionParserException e2) {
                        try {
                            String[] valuesString = tagValue.split(":");
                            if (valuesString.length == 0) {
                                throw new ExpressionParserException();
                            }
                            boolean type = false;
                            if (valuesString[0].endsWith("b") || valuesString[0].endsWith("B")) {
                                type = true;
                            }
                            int[] valuesInt = new int[valuesString.length];
                            byte[] valuesByte = new byte[valuesString.length];
                            for (int b = 0; b < valuesString.length; ++b) {
                                if (!type) {
                                    valuesInt[b] = this.getInteger(valuesString[b]);
                                    continue;
                                }
                                valuesString[b] = this.removeSuffix(valuesString[b]);
                                valuesByte[b] = this.getByte(valuesString[b]);
                            }
                            if (!type) {
                                if (valuesInt.length == 0) {
                                    throw new ExpressionParserException();
                                }
                                this.setTagValue(currTag, tagName, valuesInt);
                                continue;
                            }
                            if (valuesByte.length == 0) {
                                throw new ExpressionParserException();
                            }
                            this.setTagValue(currTag, tagName, valuesByte);
                        }
                        catch (ExpressionParserException e3) {
                            this.setTagValue(currTag, tagName, this.getString(tagValue));
                        }
                    }
                }
            }
        }
    }

    public void setTagValue(NBTBase currTag, String tagName, Object tagValue) {
        if (currTag instanceof NBTTagCompound) {
            NBTTagCompound tagCompound = (NBTTagCompound)currTag;
            if (tagValue instanceof String) {
                tagCompound.func_74778_a(tagName, (String)tagValue);
            }
            if (tagValue instanceof Boolean) {
                tagCompound.func_74757_a(tagName, ((Boolean)tagValue).booleanValue());
            }
            if (tagValue instanceof Integer) {
                tagCompound.func_74768_a(tagName, ((Integer)tagValue).intValue());
            }
            if (tagValue instanceof Float) {
                tagCompound.func_74776_a(tagName, ((Float)tagValue).floatValue());
            }
            if (tagValue instanceof Double) {
                tagCompound.func_74780_a(tagName, ((Double)tagValue).doubleValue());
            }
            if (tagValue instanceof Short) {
                tagCompound.func_74777_a(tagName, ((Short)tagValue).shortValue());
            }
            if (tagValue instanceof Byte) {
                tagCompound.func_74774_a(tagName, ((Byte)tagValue).byteValue());
            }
            if (tagValue instanceof int[]) {
                tagCompound.func_74783_a(tagName, (int[])tagValue);
            }
            if (tagValue instanceof byte[]) {
                tagCompound.func_74773_a(tagName, (byte[])tagValue);
            }
            if (tagValue instanceof NBTTagCompound) {
                tagCompound.func_74782_a(tagName, (NBTBase)((NBTTagCompound)tagValue));
            }
            if (tagValue instanceof NBTTagList) {
                tagCompound.func_74782_a(tagName, (NBTBase)((NBTTagList)tagValue));
            }
        }
        if (currTag instanceof NBTTagList) {
            NBTTagList tagList = (NBTTagList)currTag;
            if (tagValue instanceof String) {
                tagList.func_74742_a((NBTBase)new NBTTagString((String)tagValue));
            }
            if (tagValue instanceof Integer) {
                tagList.func_74742_a((NBTBase)new NBTTagInt(((Integer)tagValue).intValue()));
            }
            if (tagValue instanceof Float) {
                tagList.func_74742_a((NBTBase)new NBTTagFloat(((Float)tagValue).floatValue()));
            }
            if (tagValue instanceof Double) {
                tagList.func_74742_a((NBTBase)new NBTTagDouble(((Double)tagValue).doubleValue()));
            }
            if (tagValue instanceof Short) {
                tagList.func_74742_a((NBTBase)new NBTTagShort(((Short)tagValue).shortValue()));
            }
            if (tagValue instanceof Byte) {
                tagList.func_74742_a((NBTBase)new NBTTagByte(((Byte)tagValue).byteValue()));
            }
            if (tagValue instanceof int[]) {
                tagList.func_74742_a((NBTBase)new NBTTagIntArray((int[])tagValue));
            }
            if (tagValue instanceof byte[]) {
                tagList.func_74742_a((NBTBase)new NBTTagByteArray((byte[])tagValue));
            }
            if (tagValue instanceof NBTTagCompound) {
                tagList.func_74742_a((NBTBase)((NBTTagCompound)tagValue));
            }
            if (tagValue instanceof NBTTagList) {
                tagList.func_74742_a((NBTBase)((NBTTagList)tagValue));
            }
        }
    }

    public class ExpressionParserException
    extends Exception {
        public ExpressionParserException(String value, Exception exception) {
            super("Invalid input string: " + value + (exception instanceof ScriptException ? "\nScript Error: " + exception.getMessage() : ""));
        }

        public ExpressionParserException() {
        }
    }
}

