/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import java.util.List;
import mod.lucky.crafting.LuckyCrafting;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.item.ItemLuckyBlock;
import mod.lucky.util.LuckyFunction;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLuckyBow
extends ItemBow {
    private DropProcessor dropProcessor;
    private LuckyCrafting crafting;
    private String bowTextureName = "lucky:lucky_bow";

    public ItemLuckyBow() {
        this.func_77656_e(1000);
        this.dropProcessor = new DropProcessor();
        this.crafting = new LuckyCrafting((Item)this);
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer player, int timeLeft) {
        boolean unlimitedArrows;
        int initPower = this.func_77626_a(itemStack) - timeLeft;
        ArrowLooseEvent event = new ArrowLooseEvent(player, itemStack, initPower);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        initPower = event.charge;
        boolean bl = unlimitedArrows = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemStack) > 0;
        if (unlimitedArrows || player.field_71071_by.func_146028_b(Items.field_151032_g)) {
            float power = (float)initPower / 20.0f;
            if ((double)(power = (power * power + power * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (power > 1.0f) {
                power = 1.0f;
            }
            if (!world.field_72995_K) {
                try {
                    int luck = ItemLuckyBlock.getLuck(itemStack);
                    String[] drops = ItemLuckyBlock.getDrops(itemStack);
                    EntityArrow entityArrow = new EntityArrow(world, (EntityLivingBase)player, 1.0f);
                    if (drops != null && drops.length != 0) {
                        this.getDropProcessor().processRandomDrop(LuckyFunction.getDropsFromStringArray(drops), new DropProcessData(world, (Entity)player, entityArrow.func_174791_d()).setBowPower(power * 2.0f), luck);
                    } else {
                        this.getDropProcessor().processRandomDrop(new DropProcessData(world, (Entity)player, entityArrow.func_174791_d()).setBowPower(power * 2.0f), luck);
                    }
                }
                catch (Exception e) {
                    System.err.println("The Lucky Bow encountered and error while trying to perform a function. Error report below:");
                    e.printStackTrace();
                }
            }
            player.field_71071_by.func_146026_a(Items.field_151032_g);
            itemStack.func_77972_a(1, (EntityLivingBase)player);
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(this.bowTextureName, "inventory");
        int useTicks = stack.func_77988_m() - useRemaining;
        if (stack.func_77973_b() == this && player.func_71011_bu() != null) {
            if (useTicks >= 18) {
                modelResourceLocation = new ModelResourceLocation(this.bowTextureName + "_pulling_2", "inventory");
            } else if (useTicks > 13) {
                modelResourceLocation = new ModelResourceLocation(this.bowTextureName + "_pulling_1", "inventory");
            } else if (useTicks > 0) {
                modelResourceLocation = new ModelResourceLocation(this.bowTextureName + "_pulling_0", "inventory");
            }
        }
        return modelResourceLocation;
    }

    public void setBowTextureName(String bowTextureName) {
        this.bowTextureName = bowTextureName;
    }

    public int func_77619_b() {
        return 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public DropProcessor getDropProcessor() {
        return this.dropProcessor;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        int luck = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        list.add(StatCollector.func_74838_a((String)"item.luckyBlock.luck") + ": " + (luck == 0 ? EnumChatFormatting.GOLD : (luck < 0 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN + "+")) + String.valueOf(luck));
        if (drops != null && drops.length != 0) {
            list.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"item.luckyBlock.customDrop"));
        }
    }

    public LuckyCrafting getCrafting() {
        return this.crafting;
    }
}

