/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.resources;

import java.util.ArrayList;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.resources.BaseResource;
import mod.lucky.resources.loader.BaseLoader;
import mod.lucky.util.LuckyReader;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ResourceRecipes
extends BaseResource {
    @Override
    public void process(LuckyReader reader, BaseLoader loader) {
        try {
            String curLine;
            while ((curLine = reader.readLine()) != null) {
                String[] recipePart = curLine.split(",");
                ArrayList<Object> recipeList = new ArrayList<Object>();
                for (String part : recipePart) {
                    Item item = ValueParser.getItem(part, null);
                    ItemStack itemStack = ValueParser.getItemStack(part, null);
                    if (item != null) {
                        recipeList.add(item);
                        continue;
                    }
                    if (itemStack != null) {
                        recipeList.add(itemStack);
                        continue;
                    }
                    if (part.length() == 1 && !part.equals(recipePart[0])) {
                        recipeList.add(Character.valueOf(part.charAt(0)));
                        continue;
                    }
                    recipeList.add(part);
                }
                ItemStack itemStack = new ItemStack((Block)loader.getBlock());
                if (recipeList.get(0) instanceof Item) {
                    GameRegistry.addShapelessRecipe((ItemStack)itemStack, (Object[])recipeList.toArray());
                    continue;
                }
                GameRegistry.addRecipe((ItemStack)itemStack, (Object[])recipeList.toArray());
            }
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error reading 'recipes.txt'");
            e.printStackTrace();
        }
    }

    @Override
    public String getDirectory() {
        return "recipes.txt";
    }
}

