/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.world;

import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class DelayLuckyDrop {
    private long ticksRemaining;
    private DropProcessData processData;
    private DropProcessor dropProcessor;
    private boolean finished;

    public DelayLuckyDrop(DropProcessor dropProcessor, DropProcessData processData, long ticksRemaining) {
        this.dropProcessor = dropProcessor;
        this.processData = processData;
        this.ticksRemaining = ticksRemaining;
        this.finished = false;
    }

    public void update() {
        try {
            --this.ticksRemaining;
            if (this.ticksRemaining <= 0L) {
                this.dropProcessor.processDelayDrop(this.processData);
                this.finished = true;
            }
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error processing delay drop: " + this.processData.getDropProperties().toString());
            e.printStackTrace();
            this.finished = true;
        }
    }

    public void setDropprocessor(DropProcessor dropProcessor) {
        this.dropProcessor = dropProcessor;
    }

    public DropProcessData getProcessData() {
        return this.processData;
    }

    public long getTicksRemaining() {
        return this.ticksRemaining;
    }

    public boolean finished() {
        return this.finished;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound mainTag = new NBTTagCompound();
        mainTag.func_74782_a("processData", (NBTBase)this.processData.writeToNBT());
        mainTag.func_74772_a("ticksRemaining", this.ticksRemaining);
        return mainTag;
    }

    public void readFromNBT(NBTTagCompound tagCompound, World world) {
        this.processData = new DropProcessData(world);
        this.processData.readFromNBT(tagCompound.func_74775_l("processData"));
        this.ticksRemaining = tagCompound.func_74763_f("ticksRemaining");
    }
}

