/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.common.drop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.LoggerKt;
import mod.lucky.common.LuckyRegistry;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.DictSpec;
import mod.lucky.common.attribute.EvaluatorKt;
import mod.lucky.common.attribute.ParserError;
import mod.lucky.common.attribute.ParserKt;
import mod.lucky.common.attribute.ValueSpec;
import mod.lucky.common.drop.BaseDrop;
import mod.lucky.common.drop.GroupDrop;
import mod.lucky.common.drop.GroupDropKt;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.common.drop.SingleDropKt;
import mod.lucky.common.drop.WeightedDrop;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.jvm.internal.SourceDebugExtension;
import mod.lucky.kotlin.ranges.RangesKt;
import mod.lucky.kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u001a\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\n\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"luckChanceSpec", "Lmod/lucky/common/attribute/DictSpec;", "dropsFromStrList", "", "Lmod/lucky/common/drop/WeightedDrop;", "drops", "", "readLuckChance", "Lmod/lucky/kotlin/Pair;", "Lmod/lucky/common/attribute/DictAttr;", "dropStr", "fromString", "Lmod/lucky/common/drop/WeightedDrop$Companion;", "common"})
@SourceDebugExtension(value={"SMAP\nWeightedDrop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeightedDrop.kt\nmod/lucky/common/drop/WeightedDropKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1603#2,9:64\n1855#2:73\n1856#2:75\n1612#2:76\n1#3:74\n*S KotlinDebug\n*F\n+ 1 WeightedDrop.kt\nmod/lucky/common/drop/WeightedDropKt\n*L\n54#1:64,9\n54#1:73\n54#1:75\n54#1:76\n54#1:74\n*E\n"})
public final class WeightedDropKt {
    @NotNull
    private static final DictSpec luckChanceSpec;

    private static final Pair<String, DictAttr> readLuckChance(String dropStr) {
        Pair<String, DictAttr> pair;
        Integer extraPropIndex = ParserKt.indexOfUnnested(dropStr, 0, '@');
        if (extraPropIndex == null) {
            pair = new Pair<String, DictAttr>(dropStr, new DictAttr(null, null, false, 7, null));
        } else {
            DictAttr dictAttr;
            String newDropStr = StringsKt.substring(dropStr, RangesKt.until(0, (int)extraPropIndex));
            char[] cArray = new char[]{'@'};
            String attrStr = CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)StringsKt.substring(dropStr, RangesKt.until(extraPropIndex + 1, dropStr.length())), cArray, false, 0, 6, null), ",", null, null, 0, null, null, 62, null);
            try {
                Attr attr = EvaluatorKt.parseEvalAttr(attrStr, luckChanceSpec, LuckyRegistry.INSTANCE.getParserContext(), LuckyRegistry.INSTANCE.getSimpleEvalContext());
                Intrinsics.checkNotNull(attr, "null cannot be cast to non-null type mod.lucky.common.attribute.DictAttr");
                dictAttr = (DictAttr)attr;
            }
            catch (ParserError e) {
                GameAPIKt.getGAME_API().logError("Error reading extra drop properties '" + attrStr + "' for drop: " + dropStr, e);
                dictAttr = new DictAttr(null, null, false, 7, null);
            }
            DictAttr attr = dictAttr;
            pair = new Pair<String, DictAttr>(newDropStr, attr);
        }
        return pair;
    }

    @NotNull
    public static final WeightedDrop fromString(@NotNull WeightedDrop.Companion $this$fromString, @NotNull String dropStr) {
        Intrinsics.checkNotNullParameter($this$fromString, "<this>");
        Intrinsics.checkNotNullParameter(dropStr, "dropStr");
        Pair<String, DictAttr> pair = WeightedDropKt.readLuckChance(dropStr);
        String strippedDropStr = pair.component1();
        DictAttr extraProps = pair.component2();
        String string = strippedDropStr.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        BaseDrop innerDrop = StringsKt.startsWith$default(string, "group", false, 2, null) ? (BaseDrop)GroupDropKt.fromString(GroupDrop.Companion, strippedDropStr) : (BaseDrop)SingleDropKt.fromString(SingleDrop.Companion, strippedDropStr);
        Integer n = (Integer)extraProps.getOptionalValue("luck");
        return new WeightedDrop(innerDrop, dropStr, n != null ? n : 0, (Double)extraProps.getOptionalValue("chance"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<WeightedDrop> dropsFromStrList(@NotNull List<String> drops) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(drops, "drops");
        Iterable $this$mapNotNull$iv = drops;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            WeightedDrop it$iv$iv;
            WeightedDrop weightedDrop;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                weightedDrop = WeightedDropKt.fromString(WeightedDrop.Companion, it);
            }
            catch (Exception e) {
                LoggerKt.getLOGGER().logError("Error parsing drop: " + it, e);
                weightedDrop = null;
            }
            if (weightedDrop == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("luck", new ValueSpec(AttrType.INT)), TuplesKt.to("chance", new ValueSpec(AttrType.DOUBLE))};
        luckChanceSpec = AttributeKt.dictSpecOf(pairArray);
    }
}

