/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.java.loader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.lucky.common.LoggerKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.ListAttr;
import mod.lucky.common.drop.DropStructure;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"readLegacySchematic", "Lmod/lucky/common/drop/DropStructure;", "stream", "Ljava/io/InputStream;", "common"})
@SourceDebugExtension(value={"SMAP\nReadLegacySchematic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadLegacySchematic.kt\nmod/lucky/java/loader/ReadLegacySchematicKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1549#2:70\n1620#2,3:71\n*S KotlinDebug\n*F\n+ 1 ReadLegacySchematic.kt\nmod/lucky/java/loader/ReadLegacySchematicKt\n*L\n56#1:70\n56#1:71,3\n*E\n"})
public final class ReadLegacySchematicKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DropStructure readLegacySchematic(@NotNull InputStream stream) {
        void $this$mapTo$iv$iv;
        DictAttr dictAttr;
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            Attr attr = JavaGameAPIKt.getJAVA_GAME_API().readCompressedNBT(stream);
            Intrinsics.checkNotNull(attr, "null cannot be cast to non-null type mod.lucky.common.attribute.DictAttr");
            dictAttr = (DictAttr)attr;
        }
        catch (Exception e) {
            LoggerKt.getLOGGER().logError("Error reading legacy schematic structure", e);
            dictAttr = new DictAttr(null, null, false, 7, null);
        }
        DictAttr nbt = dictAttr;
        Vec3<Number> size = new Vec3<Number>(((Number)nbt.getValue("Width")).shortValue(), ((Number)nbt.getValue("Height")).shortValue(), ((Number)nbt.getValue("Length")).shortValue());
        byte[] blockIdBytes = (byte[])nbt.getValue("Blocks");
        byte[] blockDataBytes = (byte[])nbt.getValue("Data");
        int x = 0;
        int y = 0;
        int z = 0;
        ArrayList<SingleDrop> blockDrops = new ArrayList<SingleDrop>();
        int n = blockIdBytes.length;
        for (int i = 0; i < n; ++i) {
            String blockId;
            byte blockIdInt = blockIdBytes[i];
            byte blockDataInt = blockDataBytes[i];
            String string = JavaGameAPIKt.getJAVA_GAME_API().convertLegacyItemId(blockIdInt, blockDataInt);
            if (string == null) {
                string = "minecraft:stone";
            }
            if (!Intrinsics.areEqual(blockId = string, "minecraft:air")) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("id", AttributeKt.stringAttrOf(blockId)), TuplesKt.to("posOffset", AttributeKt.vec3AttrOf(AttrType.DOUBLE, new Vec3<Number>(x, y, z).toDouble()))};
                blockDrops.add(new SingleDrop("block", AttributeKt.dictAttrOf(pairArray), null, 4, null));
            }
            if (++x >= size.getX().intValue()) {
                x = 0;
                ++z;
            }
            if (z < size.getZ().intValue()) continue;
            z = 0;
            ++y;
        }
        Iterable $this$map$iv = nbt.getList("Entities").getChildren();
        boolean $i$f$map = false;
        Iterable blockDataInt = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Attr attr = (Attr)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type mod.lucky.common.attribute.DictAttr");
            ListAttr listAttr = (ListAttr)((DictAttr)it).get("Position");
            if (listAttr == null) {
                listAttr = AttributeKt.vec3AttrOf(AttrType.DOUBLE, new Vec3<Number>(0.0, 0.0, 0.0));
            }
            ListAttr posList = listAttr;
            Pair[] pairArray = new Pair[]{TuplesKt.to("posOffset", posList), TuplesKt.to("nbttag", it)};
            collection.add(new SingleDrop("entity", AttributeKt.dictAttrOf(pairArray), null, 4, null));
        }
        List entityDrops = (List)destination$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("size", AttributeKt.vec3AttrOf(AttrType.DOUBLE, size.toDouble()))};
        return new DropStructure(AttributeKt.dictAttrOf(pairArray), CollectionsKt.plus((Collection)blockDrops, (Iterable)entityDrops));
    }
}

