/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.mixin.nbt.IMixinNbtReadView;
import fi.dy.masa.malilib.mixin.nbt.IMixinNbtWriteView;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11371;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class NbtView {
    private static final class_8942 log = class_8942.field_60348;
    private class_11368 reader;
    private class_11372 writer;

    private NbtView() {
    }

    public static NbtView getReader(class_2487 nbt, @Nonnull class_5455 registry) {
        NbtView wrapper = new NbtView();
        wrapper.reader = class_11352.method_71417((class_8942)log, (class_7225.class_7874)registry, (class_2487)nbt);
        wrapper.writer = null;
        return wrapper;
    }

    public static NbtView getWriter(@Nonnull class_5455 registry) {
        NbtView wrapper = new NbtView();
        wrapper.reader = null;
        wrapper.writer = class_11362.method_71459((class_8942)log, (class_7225.class_7874)registry);
        return wrapper;
    }

    public class_8942 getLogger() {
        return log;
    }

    public boolean isReader() {
        return this.reader != null;
    }

    public boolean isWriter() {
        return this.writer != null;
    }

    @Nullable
    public class_11368 getReader() {
        return this.reader;
    }

    @Nullable
    public class_11372 getWriter() {
        return this.writer;
    }

    @Nullable
    public class_11352 asNbtReader() {
        return (class_11352)this.reader;
    }

    @Nullable
    public class_11362 asNbtWriter() {
        return (class_11362)this.writer;
    }

    @Nullable
    public class_11371 getReaderContext() {
        if (this.isReader()) {
            return ((IMixinNbtReadView)this.reader).malilib_getContext();
        }
        return null;
    }

    @Nullable
    public DynamicOps<?> getWriterOps() {
        if (this.isWriter()) {
            return ((IMixinNbtWriteView)this.writer).malilib_getOps();
        }
        return null;
    }

    @Nullable
    public class_2487 readNbt() {
        if (this.isReader()) {
            return ((IMixinNbtReadView)this.reader).malilib_getNbt();
        }
        if (this.isWriter()) {
            return ((IMixinNbtWriteView)this.writer).malilib_getNbt();
        }
        return null;
    }

    @Nullable
    public NbtView writeNbt(@Nonnull class_2487 nbtIn) {
        if (this.isReader()) {
            return null;
        }
        for (String key : nbtIn.method_10541()) {
            Objects.requireNonNull(this.readNbt()).method_10566(key, nbtIn.method_10580(key));
        }
        return this;
    }

    public <T> Optional<T> readFlatMap(MapCodec<T> mapCodec) {
        if (this.isWriter()) {
            return Optional.empty();
        }
        return NbtUtils.readFlatMap(Objects.requireNonNullElse(this.readNbt(), new class_2487()), mapCodec);
    }

    public <T> Optional<T> readCodec(String key, Codec<T> codec) {
        if (this.isWriter()) {
            return Optional.empty();
        }
        try {
            return this.reader.method_71426(key, codec);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("NbtView#readCodec: Exception reading from key '{}'; {}", (Object)key, (Object)err.getLocalizedMessage());
            return Optional.empty();
        }
    }

    public <T> class_2487 writeFlatMap(MapCodec<T> mapCodec, T value) {
        if (this.isReader()) {
            return new class_2487();
        }
        this.writeNbt(NbtUtils.writeFlatMap(mapCodec, value));
        return this.readNbt();
    }

    public <T> class_2487 writeCodec(String key, Codec<T> codec, T value) {
        if (this.isReader()) {
            return new class_2487();
        }
        try {
            this.writer.method_71468(key, codec, value);
            return this.readNbt();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("NbtView#writeCodec: Exception writing to key '{}'; {}", (Object)key, (Object)err.getLocalizedMessage());
            return new class_2487();
        }
    }
}

